/*
 * @(#)ObjectModelBsh.java  1.0  23. M�rz 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodelbsh;

import ch.hslu.cm.oo.objectmodel.*;
import ch.hslu.cm.simulation.*;
import java.util.*;

/**
 * Simulates an object model, which can be scripted using BeanShell.
 *
 * @author  Werner Randelshofer
 * @version 1.0 23. M�rz 2004  Created.
 */
public class ObjectModelBsh extends ObjectModel {
    private SimulationConsole console;
    
    /** Creates a new instance. */
    public ObjectModelBsh() {
    }
    
    public SimulationConsole getConsole() {
        if (console == null) {
            console = new SimulationConsole();
        }
        return console;
    }
    
    public SimulatedObject create(int simulatedConcept) {
        SimulatedObject elem;
        switch (simulatedConcept) {
            case OBJECT :
                elem = new OMBshObject();
                break;
            case CLASS :
                elem = new OMBshClass();
                break;
            case ASSOCIATION :
                elem = new OMAssociation();
                break;
            case LINK :
                elem = new OMBshLink();
                break;
            case GENERALIZATION :
                elem = new OMGeneralization();
                break;
            case DEPENDENCY :
                elem = new OMDependency();
                break;
            default :
                throw new IllegalArgumentException(simulatedConcept+"");
        }
        return elem;
    }
}
